package com.jianLing.demo.vo;


import java.util.StringJoiner;

/**
 * 回调参数
 */
public class CallbackParam
{


	/** 时间戳 */
	private String timestamp;
	/** 系统订单号 */
	private String orderNo;
	/** 商户号 */
	private String merchno;
	/** 商户订单号 */
	private String orderId;
	/** 订单金额（元） */
	private String amount;
	/** 收款账户 */
	private String account;
	/** 交易类型 */
	private String tradeType;
	/** 卡号 */
	private String cardNo;
	/** 银行编码 */
	private String bankCode;
	/** 银行名称 */
	private String bankName;
	/** 开户行 */
	private String depositBank;
	/** 商户附加信息 */
	private String attach;
	/** 订单状态 */
	private String status;
	/** 签名 */
	private String sign;
	/** 下发类型（1：人民币；2：USDT；3：越南盾；4：印度卢比） */
	private String cashType;
	/** 请求货币（1：人民币；2：USDT；3：越南盾；4：印度卢比） */
	private String requestCurrency;
	/** api接口版本 */
	private String apiVersion;

	public String getTimestamp() {
		return timestamp;
	}

	public CallbackParam setTimestamp(String timestamp) {
		this.timestamp = timestamp;
		return this;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public CallbackParam setOrderNo(String orderNo) {
		this.orderNo = orderNo;
		return this;
	}

	public String getMerchno() {
		return merchno;
	}

	public CallbackParam setMerchno(String merchno) {
		this.merchno = merchno;
		return this;
	}

	public String getOrderId() {
		return orderId;
	}

	public CallbackParam setOrderId(String orderId) {
		this.orderId = orderId;
		return this;
	}

	public String getAmount() {
		return amount;
	}

	public CallbackParam setAmount(String amount) {
		this.amount = amount;
		return this;
	}

	public String getAccount() {
		return account;
	}

	public CallbackParam setAccount(String account) {
		this.account = account;
		return this;
	}

	public String getTradeType() {
		return tradeType;
	}

	public CallbackParam setTradeType(String tradeType) {
		this.tradeType = tradeType;
		return this;
	}

	public String getCardNo() {
		return cardNo;
	}

	public CallbackParam setCardNo(String cardNo) {
		this.cardNo = cardNo;
		return this;
	}

	public String getBankCode() {
		return bankCode;
	}

	public CallbackParam setBankCode(String bankCode) {
		this.bankCode = bankCode;
		return this;
	}

	public String getBankName() {
		return bankName;
	}

	public CallbackParam setBankName(String bankName) {
		this.bankName = bankName;
		return this;
	}

	public String getDepositBank() {
		return depositBank;
	}

	public CallbackParam setDepositBank(String depositBank) {
		this.depositBank = depositBank;
		return this;
	}

	public String getAttach() {
		return attach;
	}

	public CallbackParam setAttach(String attach) {
		this.attach = attach;
		return this;
	}

	public String getStatus() {
		return status;
	}

	public CallbackParam setStatus(String status) {
		this.status = status;
		return this;
	}

	public String getSign() {
		return sign;
	}

	public CallbackParam setSign(String sign) {
		this.sign = sign;
		return this;
	}

	public String getCashType() {
		return cashType;
	}

	public void setCashType(String cashType) {
		this.cashType = cashType;
	}

	public String getRequestCurrency() {
		return requestCurrency;
	}

	public void setRequestCurrency(String requestCurrency) {
		this.requestCurrency = requestCurrency;
	}

	public String getApiVersion() {
		return apiVersion;
	}

	public void setApiVersion(String apiVersion) {
		this.apiVersion = apiVersion;
	}

	@Override
	public String toString() {
		return new StringJoiner(", ", CallbackParam.class.getSimpleName() + "[", "]")
				.add("timestamp='" + timestamp + "'")
				.add("orderNo='" + orderNo + "'")
				.add("merchno='" + merchno + "'")
				.add("orderId='" + orderId + "'")
				.add("amount='" + amount + "'")
				.add("account='" + account + "'")
				.add("tradeType='" + tradeType + "'")
				.add("cardNo='" + cardNo + "'")
				.add("bankCode='" + bankCode + "'")
				.add("bankName='" + bankName + "'")
				.add("depositBank='" + depositBank + "'")
				.add("attach='" + attach + "'")
				.add("status='" + status + "'")
				.add("sign='" + sign + "'")
				.add("cashType='" + sign + "'")
				.add("requestCurrency='" + sign + "'")
				.add("apiVersion='" + sign + "'")
				.toString();
	}
}
