package com.jianLing.demo.vo;


import java.util.StringJoiner;

/**
 * 下单响应vo
 */
public class PlaceOrderResp {

    /** 响应内容 */
    private ResponseContent responseContent;
    /** 签名 */
    private String sign;

    public ResponseContent getResponseContent() {
        return responseContent;
    }

    public void setResponseContent(ResponseContent responseContent) {
        this.responseContent = responseContent;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PlaceOrderResp.class.getSimpleName() + "[", "]")
                .add("responseContent=" + responseContent)
                .add("sign='" + sign + "'")
                .toString();
    }


    /**
     * 下单响应实体
     */
    public static class ResponseContent {
        /** 状态码 */
        private Integer code;
        /** 状态信息 */
        private String msg;
        /** 响应时间 */
        private String timestamp;
        /** 商户号 */
        private String merchno;
        /** 商户订单号 */
        private String orderId;
        /** 系统订单号 */
        private String orderNo;
        /** 订单状态 */
        private Integer status;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getMerchno() {
            return merchno;
        }

        public void setMerchno(String merchno) {
            this.merchno = merchno;
        }

        public String getOrderId() {
            return orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getOrderNo() {
            return orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", ResponseContent.class.getSimpleName() + "[", "]")
                    .add("code=" + code)
                    .add("msg='" + msg + "'")
                    .add("timestamp='" + timestamp + "'")
                    .add("merchno='" + merchno + "'")
                    .add("orderId='" + orderId + "'")
                    .add("orderNo='" + orderNo + "'")
                    .add("status=" + status)
                    .toString();
        }
    }
}
